<?php
/**
 * Plugin Name: Danava Image Processor
 * Plugin URI: https://danava-ai.ir/
 * Description: Process WordPress gallery images using Danava AI
 * Version: 1.1.0
 * Author: Mohammad Erfani
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: danava-image-processor
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit();
}

// Define plugin constants
define("DANAVA_PLUGIN_DIR", plugin_dir_path(__FILE__));
define("DANAVA_PLUGIN_URL", plugin_dir_url(__FILE__));

// Include necessary files
require_once DANAVA_PLUGIN_DIR . "includes/class-danava-settings.php";
require_once DANAVA_PLUGIN_DIR . "includes/class-danava-api-handler.php";
require_once DANAVA_PLUGIN_DIR . "includes/class-danava-gallery.php";
require_once DANAVA_PLUGIN_DIR . "includes/class-danava-woocommerce.php";

// Initialize the plugin
class Danava_Image_Processor
{
    public function __construct()
    {
        add_action("plugins_loaded", [$this, "init"]);
    }

    public function init()
    {
        // Initialize components
        new Danava_Settings();
        new Danava_API_Handler();
        new Danava_Gallery();
        new Danava_WooCommerce();
    }

}

// Start the plugin
new Danava_Image_Processor();
