<?php
if (!defined("ABSPATH")) {
    exit();
} ?>
		<div class="wrap">
			<div class="danava-image-editor">
				<div class="editor-header">
					<div class="editor-title">
						<h1><?php esc_html_e("Image Editor", "danava-image-processor"); ?></h1>
						<p class="editor-subtitle"><?php esc_html_e("To get started, select images from the WordPress gallery and write your request.", "danava-image-processor"); ?></p>
					</div>
					<div class="header-meta">
						<div class="credit-badge" title="<?php esc_attr_e("Remaining Credit", "danava-image-processor"); ?>">
							<i class="fas fa-coins"></i>
							<span class="credit-label"><?php esc_html_e(
           "Credit:",
           "danava-image-processor",
       ); ?></span>
							<span id="credit-amount">...</span>
						</div>
						<a class="btn btn-outline-secondary btn-sm" href="https://danava-ai.ir/payment/credit_plans/" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e("Increase Credit", "danava-image-processor"); ?>
						</a>
					</div>
				</div>

				<div class="editor-grid">
					<!-- Left: Images selection and preview -->
					<section class="editor-card">
						<header class="card-head">
							<h3><?php esc_html_e("Select Reference Images", "danava-image-processor"); ?></h3>
							<p><?php esc_html_e("Select up to 3 images from the media library.", "danava-image-processor"); ?></p>
						</header>

						<!-- Gallery Sections Wrapper -->
						<div class="gallery-sections-wrapper">
							<!-- WordPress Gallery Section -->
							<div class="gallery-section">
								<div class="gallery-area">
									<div class="gallery-content">
										<div class="gallery-icon"><i class="fas fa-images"></i></div>
										<h5><?php esc_html_e("Select from WordPress Gallery", "danava-image-processor"); ?></h5>
										<p><?php esc_html_e("Select images from the WordPress media library", "danava-image-processor"); ?></p>
										<button type="button" class="btn btn-primary" id="select-gallery-images">
											<i class="fas fa-plus"></i>
											<?php esc_html_e("Add Images", "danava-image-processor"); ?>
										</button>
									</div>
								</div>
							</div>

							<?php if (class_exists("WooCommerce")): ?>
							<!-- WooCommerce Products Section -->
							<div class="gallery-section">
								<div class="gallery-area">
									<div class="gallery-content">
										<div class="gallery-icon"><i class="fas fa-shopping-cart"></i></div>
										<h5><?php esc_html_e("Select from WooCommerce Products", "danava-image-processor"); ?></h5>
										<p><?php esc_html_e("Select product images from your store", "danava-image-processor"); ?></p>
										<button type="button" class="btn btn-primary" id="select-woo-products">
											<i class="fas fa-store"></i>
											<?php esc_html_e("Select from Products", "danava-image-processor"); ?>
										</button>
									</div>
								</div>
							</div>
							<?php endif; ?>
						</div>

						<!-- Selected Images Display -->
						<div class="selected-images-section mt-4" id="selected-images-section">
							<h4 class="mb-3"><?php esc_html_e("Selected Images", "danava-image-processor"); ?> <span class="muted"><?php esc_html_e("(max 3)", "danava-image-processor"); ?></span></h4>
							<div class="selected-images-grid" id="selected-images-grid"></div>
							<div class="no-selected-images text-center text-muted d-none" id="no-selected-images">
								<p><?php esc_html_e("No images selected yet.", "danava-image-processor"); ?></p>
							</div>
						</div>
					</section>

					<!-- Right: Prompt and tips -->
					<aside class="editor-card">
						<header class="card-head">
							<h3><?php esc_html_e("Description and Output Style", "danava-image-processor"); ?></h3>
							<p><?php esc_html_e("Select an option or write your custom description.", "danava-image-processor"); ?></p>
						</header>

						<div class="prompt-section">
							<div class="form-group">
								<label for="img-gen-prompt"><?php esc_html_e("Requested Changes*", "danava-image-processor"); ?></label>
								<div class="prompt-options mb-2" id="prompt-options">
									<?php
         $prompts = get_option("danava_prompts", []);

         // Default prompts if none exist
         if (empty($prompts)) {
             $prompts = [
                 [
                     "label" => "Professional Studio",
                     "value" =>
                         "Convert to professional studio photo, decor matching the product, preserve all product details completely, high resolution, harmonious color combinations",
                 ],
                 [
                     "label" => "Quality Enhancement",
                     "value" =>
                         "Improve image quality with resolution enhancement, reduce digital noise, adjust contrast and brightness, enhance colors using advanced algorithms, preserve fine details",
                 ],
                 [
                     "label" => "White Background",
                     "value" =>
                         "Change background to pure white with complete removal of background elements, keep product centered in image, adjust lighting to highlight product",
                 ],
                 [
                     "label" => "Shadow and Depth",
                     "value" =>
                         "Add natural shadows and three-dimensional depth using advanced techniques, create sense of volume and texture, adjust lighting to highlight product features, maintain image realism",
                 ],
                 [
                     "label" => "Minimal Style",
                     "value" =>
                         "Convert to minimal style with simple background, focus on product, remove unnecessary elements, clean modern design, maintain visual appeal, preserve details",
                 ],
                 [
                     "label" => "Professional Lighting",
                     "value" =>
                         "Add professional lighting using advanced studio techniques, adjust light intensity, create soft shadows, highlight product features, enhance colors and contrast",
                 ],
                 [
                     "label" => "Product Zoom",
                     "value" =>
                         "Zoom in on product while maintaining high quality, focus on important details, adjust image composition, improve resolution in zoomed area, maintain overall image balance",
                 ],
             ];
         }

         foreach ($prompts as $prompt) {
             echo '<span class="option-btn" data-value="' .
                 esc_attr($prompt["value"]) .
                 '">' .
                 esc_html($prompt["label"]) .
                 "</span>";
         }
         ?>
								</div>
								<textarea name="prompt" id="img-gen-prompt" rows="6" class="form-control" placeholder="<?php esc_attr_e("Example: white background, soft studio lighting, emphasis on product details...", "danava-image-processor"); ?>"></textarea>
							</div>
						</div>


					</aside>
				</div>

				<!-- Actions -->
				<div class="editor-actions">
					<button type="submit" id="main-submit-btn" class="btn btn-success btn-lg">
						<i class="fas fa-magic"></i>
						<?php esc_html_e("Start Image Generation", "danava-image-processor"); ?>
					</button>
				</div>
			</div>
		</div>

		<?php if (class_exists("WooCommerce")): ?>
		<!-- WooCommerce Product Selector Modal -->
		<div class="woo-product-selector-modal" id="woo-product-selector-modal">
			<div class="woo-product-selector-content">
				<div class="woo-modal-header">
					<h2><?php esc_html_e("Select Product", "danava-image-processor"); ?></h2>
					<button class="woo-modal-close">&times;</button>
				</div>
				<div class="woo-modal-body">
					<div class="woo-search-section">
						<div class="woo-search-wrapper">
							<input type="text" id="woo-product-search" class="woo-search-input" placeholder="<?php esc_attr_e("Search for product...", "danava-image-processor"); ?>">
							<i class="fas fa-search woo-search-icon"></i>
							<div class="woo-search-spinner">
								<i class="fas fa-spinner fa-spin"></i>
							</div>
						</div>
					</div>

					<div class="woo-loading" id="woo-products-loading">
						<i class="fas fa-spinner fa-spin"></i>
						<p><?php esc_html_e("Loading products...", "danava-image-processor"); ?></p>
					</div>

					<div class="woo-no-products" id="woo-no-products" style="display: none;">
						<i class="fas fa-box-open"></i>
						<h3><?php esc_html_e("No products found", "danava-image-processor"); ?></h3>
						<p><?php esc_html_e("No products were found with this search.", "danava-image-processor"); ?></p>
					</div>

					<div class="woo-products-grid" id="woo-products-grid"></div>
				</div>
			</div>
		</div>

		<!-- WooCommerce Product Images Modal -->
		<div class="woo-images-modal" id="woo-images-modal">
			<div class="woo-images-modal-content">
				<div class="woo-images-modal-header">
					<h3 id="woo-images-modal-title"><?php esc_html_e("Product Images", "danava-image-processor"); ?></h3>
					<button class="woo-images-modal-close">&times;</button>
				</div>
				<div class="woo-images-modal-body">
					<div class="woo-images-grid" id="woo-images-grid"></div>
				</div>
				<div class="woo-images-modal-footer">
					<div class="woo-selected-count" id="woo-selected-images-count">
						<strong>0</strong> <?php esc_html_e("images selected", "danava-image-processor"); ?>
					</div>
					<div class="woo-images-actions">
						<button type="button" class="button button-secondary" id="cancel-image-selection"><?php esc_html_e("Cancel", "danava-image-processor"); ?></button>
						<button type="button" class="button button-primary" id="confirm-image-selection"><?php esc_html_e("Confirm Selection", "danava-image-processor"); ?></button>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>
