<?php
/**
 * Uninstall Danava Image Processor
 *
 * Fired when the plugin is uninstalled.
 *
 * @package Danava_Image_Processor
 * @since 1.0.0
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete all plugin-related post meta data
 *
 * @since 1.0.0
 */
function danava_delete_plugin_post_meta() {
    global $wpdb;

    // Delete all post meta for Danava generated images
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s AND meta_value = %s",
            '_wp_attachment_image_alt',
            'Danava Generated Image'
        )
    );
}

/**
 * Delete all plugin options
 *
 * @since 1.0.0
 */
function danava_delete_plugin_options() {
    delete_option('danava_api_key');
    delete_option('danava_api_url');
    delete_option('danava_model');
    delete_option('danava_prompts');
}

// Delete plugin options for single site
danava_delete_plugin_options();
danava_delete_plugin_post_meta();

// For multisite installations
if (is_multisite()) {
    $sites = get_sites(['number' => 0]);
    $original_blog_id = get_current_blog_id();

    foreach ($sites as $site) {
        switch_to_blog($site->blog_id);

        danava_delete_plugin_options();
        danava_delete_plugin_post_meta();
    }

    switch_to_blog($original_blog_id);
}

// Clear any cached data
wp_cache_flush();
